#affymetrix芯片数据处理
#输入affyametrix数据库的一系列CEL文件，输出一个表达矩阵，包括gene_symbol以及ensembl_id
setwd('H:/project')
library(oligo)
library(ggplot2)
library(reshape2)
library(dplyr)

remove(list = ls())
GEO_id='GSE2171'
platform_id='GPL201'
# tiss_type='tissue'
tiss_type='PBMC_from_Peripheral_blood'

# pkgname='hgfocus.db'
outliers=NA
useGEO_file=T
doQualitycontrol=T
first_time_for_pdata=F
get_expression_matrix=T
perform_result_creation=T
is_mas5_call=T
detectionPval_based_filter=T
seperate_group=T
#读取原始数据文件
file_path=paste0('H:/HIV_microarray_data_GEO/',tiss_type,'/',platform_id,'_affymetrix/',GEO_id,'_RAW')#这里记得替换成原始数据存放的路径
celfiles=list.files(file_path)
data.raw=oligo::read.celfiles(filenames = file.path(file_path,celfiles)) #这里oligo会自动尝试安装CEL包对应的注释包并自动挂包
length(celfiles)


#step1 基因芯片质量控制以及表达矩阵转换
if(doQualitycontrol==T){
#质量控制部分
library(arrayQualityMetrics)
# arrayQualityMetrics(expressionset = data.raw,
#                     outdir = paste0('results/',GEO_id,'_QCreport'),
#                     force = T,reporttitle = paste0('arrayQualityMetrics report for ',GEO_id),spatial = T,do.logtransform = T)
data.qc=prepdata(expressionset = data.raw,intgroup = c(),do.logtransform = T)
bo=aqm.boxplot(data.qc)
bo_stat=bo@outliers@statistic
write.table(as.data.frame(bo_stat),file = paste0('results/',GEO_id,'_qc_boxplot_Ka_values.txt'),sep = '\t')
hp=aqm.heatmap(data.qc)
hp_stat=hp@outliers@statistic
write.table(as.data.frame(bo_stat),file = paste0('results/',GEO_id,'_qc_distance_pheatmap_Sa_values.txt'),sep = '\t')
aqm.writereport(modules = list(bo,hp),reporttitle = paste0('arrayQualityMetrics report for ',GEO_id),outdir = paste0('results/',GEO_id,'_QCreport'),arrayTable = data.qc$pData)
#获取离群样本
bo_outliers=names(bo@outliers@which)
hp_outliers=names(bo@outliers@which)
# ma_outliers=names(bo@outliers@which)
outliers=intersect(bo_outliers,hp_outliers)
}
#去除未通过质控的样本
celfiles=celfiles[!(celfiles%in%outliers)]
remove(data.raw)
data.raw=read.celfiles(filenames = file.path(file_path,celfiles)) #这里oligo会自动尝试安装CEL包对应的注释包并自动挂包
length(celfiles)
gc()
#step1.1 原始矩阵空值填补，表达矩阵获取，删除低质量探针，检查表达矩阵空值，探针注释
if(get_expression_matrix==T){
  #表达量计算,获取表达矩阵
  #RMA算法获取探针组水平表达矩阵
  #RMA输出的表达值已经是log变换后的值
  #去除数据中的空值
  #检查数据集中是否有空值
  has_na=any(is.na(exprs(data.raw)))
  has_na_2=any(!nzchar(exprs(data.raw))) #nzchar为真时表明不是空字符串，为假时表明是空字符串
  #如果有，需要进行填补
  
  data.rma=oligo::rma(data.raw)
  data_expr=exprs(data.rma)
  dim(data_expr)
  
  data_expr1=exprs(data.raw)
  #低质量探针的删除
  #获取不同样本所属的分组情况
  if(first_time_for_pdata==T){
    #用GEOquery包下载GSE数据集的Series_matrix
    
    
    #数据处理：1.获取矩阵后对总体表达量进行矫正
    library(GEOquery)
    library(stringr)
    # library(tidyverse)
    #网速不快才用，本地有文件就不用了
    # library(GEOmirror)
    # eSet=geoChina(GEO_id)
    #如果可以正常下载，就不用镜像了
    #下载文件
    gset=getGEO(filename = paste0('H:/HIV_microarray_data_GEO/',tiss_type,'/',platform_id,'_affymetrix/',GEO_id,'_series_matrix.txt.gz'),destdir = '.',GSEMatrix = T,AnnotGPL = F,getGPL = F)
    #查看pdata数据框的分组信息情况
    pdata=pData(gset[1])
    
    table(pdata$source_name_ch1)
    #如果series_matrix未提供信息，需要自己设置分组
    #手动分组 不推荐使用，只在分组不明确时用
    #读取分组文件
    group_table=read.table(paste0('data/',GEO_id,'_group.txt'),sep = '\t',header = T)
    pdata$sample_id=rownames(pdata)
    pdata=merge(pdata,group_table,by='sample_id')
    write.table(pdata,file = paste0('results/',GEO_id,'_pdata.txt'),sep = '\t',quote = F)
    sample2id=pdata[,which(colnames(pdata) %in% c('geo_accession','group'))]
    #根据分组列信息分配组名
    pdata=pdata[pdata$source_name_ch1=='PBMC samples at week 0',]
    pdata$group='HIV_ART'
    sample2id=pdata[,which(colnames(pdata) %in% c('geo_accession','group'))]
    write.table(pdata,file = paste0('results/',GEO_id,'_pdata.txt'),sep = '\t',quote = F)
    #强制指定每种方法的分组
    pdata=pdata %>%
      # filter(column!='c') %>%
      # mutate(group=ifelse(title=='Patient 1','HIV_nonART',ifelse(title=='Patient 2','HIV_ART',ifelse(title=='Patient 3','HIV_ART',NA))))
      mutate(group=ifelse(grepl('normal',characteristics_ch1.2),'HIV_free',NA))
    setwd('H:/project')
    write.table(pdata,file = paste0('results/',GEO_id,'_pdata.txt'),sep = '\t',quote = F)
    sample2id=pdata[,which(colnames(pdata) %in% c('geo_accession','group'))]
    
    
    
    
  }else{
    pdata=read.table(paste0('H:/project/results/',tiss_type,'/affymetrix/matrix/',GEO_id,'_pdata.txt'),sep = '\t',fill = T,header = F,row.names = NULL,quote = "")
    # pdata[1,ncol(pdata)]="" #有时候excel处理过的pdata格式正确但是对应位置是NA，就需要填一个空的东西进去
    if(pdata[1,ncol(pdata)]==''|is.na(pdata[1,ncol(pdata)])){
      pdata[1,]=c('',pdata[1,-length(pdata[1,])])
      colnames(pdata)=pdata[1,]
      pdata=pdata[-1,]
      rownames(pdata)=pdata[,1]
      pdata=pdata[,-1]
    }else if(ncol(pdata)==2){
      colnames(pdata)=pdata[1,]
      pdata=pdata[-1,]
    }else{stop('Check pdata file, fix it manually if the problem is too complicated!')
    }
    sample2id=pdata[,which(colnames(pdata) %in% c('geo_accession','group'))]
  }
   
  
  
  
  #根据官方文档，对于affymetrix芯片，计算探针的P/A call，筛选掉在50%以上样本中为A的探针组
  if(detectionPval_based_filter==T){
  pacall_list=oligo::paCalls(data.raw)
    if(is_mas5_call==T){
      pacall=pacall_list$calls
      probe_id_list=rownames(pacall)
      pacall_value=pacall_list$p
      if(seperate_group){
        #获取不同样本所在的分组，后续统计阈值时，舍去在所有不同的分组中超过50%样本中pacall均为A的探针
        library(stringr)
        colnames(pacall)=sapply(colnames(pacall),function(x){
          if(x %in% c('gene_symbol','ENSEMBL_id')){
            return(x)
          } else{
            return(str_extract(x,'GSM\\d*'))
          }
        })
        dict0=setNames(sample2id$group,sample2id$geo_accession)#生成一个表达矩阵列名于accession_id对应关系的字典
        colnames(pacall)=paste0(dict0[colnames(pacall)])
        group_tmp=unique(colnames(pacall))
        sample_tmp=c()
        for(single_group_tmp in group_tmp){
          pacall_sub=pacall[,colnames(pacall)%in%single_group_tmp]
          probe_remove_sub=rownames(pacall_sub)[(apply(pacall_sub,1,function(x)sum(grepl('A',x))))>(ncol(pacall_sub)*0.5)]
          sample_tmp=c(sample_tmp,probe_remove_sub)
        }
        sample_tmp=as.data.frame(table(sample_tmp))
        sample_tmp$sample_tmp=as.character(sample_tmp$sample_tmp)
        probe_remove=sample_tmp[which(sample_tmp$Freq==length(group_tmp)),][[1]]
        probe_keep=setdiff(probe_id_list,probe_remove)
        data_expr=data_expr[rownames(data_expr) %in% probe_keep,]
        
      }else{
        # print(head(pacall))
        probe_remove=rownames(pacall)[(apply(pacall,1,function(x)sum(grepl('A',x))))>(ncol(pacall)*0.5)]
        probe_keep=rownames(pacall)[!(apply(pacall,1,function(x)sum(grepl('A',x))))>(ncol(pacall)*0.5)]
        data_expr=data_expr[rownames(data_expr) %in% probe_keep,]
      }
    
  }else{
    
      probe_remove=rownames(pacall_list)[(apply(pacall_list,1,function(x)sum(x<0.05)))>(ncol(pacall_list)*0.5)]
      probe_keep=rownames(pacall_list)[!(apply(pacall_list,1,function(x)sum(x<0.05)))>(ncol(pacall_list)*0.5)]
    probe_remove=as.numeric(probe_remove)
    probe_keep=as.numeric(probe_keep)
    pinfo=getProbeInfo(data.raw)
    fids_keep=pinfo[pinfo$fid %in% probe_keep,2]
    fids_remove=pinfo[pinfo$fid %in% probe_remove,2]
    data_expr=data_expr[rownames(data_expr) %in% fids_keep,]
    
  }
  dim(data_expr)
  
  }else{
  library(genefilter)
  data.filt=nsFilter(data.rma,require.entrez = F,remove.dupEntrez = F,var.func = IQR,var.cutoff = 0.5,filterByQuantile = T) #这里用默认方法进行筛选，将探针
  filt.log=data.filt$filter.log
  data_expr=exprs(data.filt$eset)
  }
  #去除数据中的空值
  #检查数据集中是否有空值
  #使用impute包填充缺失值
  expr_has_na=any(is.na(data_expr))
  expr_has_na
  #如果存在缺失值就填充缺失值
  if(expr_has_na==T){
    library(impute)
    data_expr.knn=impute.knn(data_expr,maxp=30000)
    sum(is.na(data_expr))
  }
  
  
  
  #表达矩阵探针注释
  #首先根据GPL编号获取对应的注释包，然后加载
  # BiocManager::install('hgfocus.db')
  
  
  #如果没有注释包就用GEO的注释包（几乎是不可能的）
  # useGEO_file=T
  #使用GEO下载的注释文件
    if(useGEO_file==T){
    library(stringr)
    library(GEOquery)
    annoset = getGEO(filename = paste0('H:/annotation_file/affymetrix/',platform_id,'.annot.gz'),destdir = ".")
    b = annoset@dataTable@table
    colnames(b)
    ids2 = b[,c("ID","Gene symbol")]
    
    
    colnames(ids2) = c("probe_id","symbol")
    ids2 = ids2[ids2$symbol!="" & ids2$symbol!='---' ,] #删除没有对应到基因的探针以及涉及重叠基因的探针，这些探针的gene_symbol中有被///隔开的一系列基因名，这些基因之间因为有重叠会被探针识别，为了减少分析的复杂程度，暂时删去这些探针
   

    gene_ids=ids2
    
    
    
  }else{
    do.call('library',list(pkgname))
    # ls('hugene10sttranscriptcluster.db')#查看包中对应的数据集，此处是获取探针-基因Symbol之间关系，应用 hgfocusSYMBOL
    #gene_ids=toTable(hgu133plus2SYMBOL)
    symbol=get(paste0(sub("\\.db$", "", pkgname), "SYMBOL"), envir = asNamespace(pkgname))
    gene_ids=toTable(symbol)
    # write.table(gene_ids,file = 'results/GPL201_probe_id2symbol.txt',sep = '\t',quote = F,row.names = F)
  }
  
   dim(data_expr)
  #除去表达矩阵中存在但是探针注释集中没有即没有对应基因的探针，这些探针对应不到任何记录中的基因
  data_expr=data_expr[rownames(data_expr) %in% gene_ids$probe_id,]
  dim(data_expr)
  #更改探针集合中顺序使得顺序与表达矩阵的一致
  gene_ids=gene_ids[match(rownames(data_expr),gene_ids$probe_id),] #match函数是返回第一个输入的每个元素在第二个输入中的位置，这里将第二个输入即gene_ids中各行顺序按表达矩阵的行进行了重排
  
  #通过probe_id将同symbol对应的多个探针进行分组
  #计算每组探针表达量平均值，取均值最大的探针作为symbol对应的唯一探针
  #此处的 by函数 作用是，根据第二个参数将第一个参数分成若干组
  tmp = by(data_expr,
           gene_ids$symbol,
           function(x) rownames(x)[which.max(rowMeans(x))]) 
  #还可以取探针中中位数最大的探针
  # tmp = by(exp,
  #           gene_ids$symbol,
  #           function(x) rownames(x)[which.max(apply(x,1,median))])
  
  probes = as.character(tmp)
  dim(data_expr)
  exp1 = data_expr[rownames(data_expr) %in% probes,] # 过滤有多个探针的基因
  dim(exp1)
  
  #这里先使用平均数最大的探针进行分析
  
  rownames(exp1)=gene_ids[match(rownames(exp1),gene_ids$probe_id),2]
  
  #处理探针对应重叠基因的情况，将这些探针分成完全相同的行，每行都只有一个基因
  df=exp1
  rownames <- rownames(df)

  # 使用strsplit函数将行名分割，得到一个列表
  split_names <- lapply(rownames, function(x) {
    if (grepl("///", x)) {
      return(strsplit(x, "///")[[1]])
    } else {
      return(x)
    }
  })
  
  # 创建一个新的数据框，每个被///分隔的字符串单独成为一行
  df_new <- df[rep(seq_len(nrow(df)), sapply(split_names, length)), ]
  
  # 使用unlist函数将列表转化为向量，并更新新数据框的行名
  rownames(df_new) <- unlist(split_names)
  exp1=df_new
  
  
  
  #挖出来的探针有可能与其他只匹配单个探针的基因名一致，我们取多个相同基因名的行中，表达值平均值最大的那行作为该基因的行
  df_new1=exp1
  index=order(rowMeans(df_new1),decreasing = T)
  df_new1_ordered=df_new1[index,]
  keep=!duplicated(rownames(df_new1_ordered))
  df_new1_ordered=df_new1_ordered[keep,]
  exp1=df_new1_ordered
  dim(exp1)
  exp1=as.data.frame(exp1)
  HUGO_full_table=read.table(file = 'data/NCBI_annotation_24_4_22.txt',sep = '\t',quote = "",header = T,fill = T)
  HUGO_full_table.sub.specials=HUGO_full_table[HUGO_full_table$type=='Is alias/previous name of multi genes',] #挑选出同时为多个基因现用名但是本身不是现用名的基因
  special.symbols=unique(HUGO_full_table.sub.specials$all_possible_query_names) #保存这些symbol
  HUGO_full_table.sub=HUGO_full_table[!HUGO_full_table$type%in%c('Is alias/previous name of multi genes'),] #去除上面提及的symbol
  HUGO_full_table.sub=HUGO_full_table.sub[!((HUGO_full_table.sub$type=='Is approved_symbol & alias/previous name of other gene')& (HUGO_full_table.sub$Approved_symbol!=HUGO_full_table.sub$all_possible_query_names)),]#有些基因本身是现用名，但是也是别的基因的别名，这种情况当作基因本身是现用名，不考虑它本身是别的基因的别名的情况
  any(duplicated(HUGO_full_table.sub$all_possible_query_names)) #检查输入的symbol是否有重复值
  dict_HUGO=setNames(HUGO_full_table.sub$Approved_symbol,HUGO_full_table.sub$all_possible_query_names) #构建搜索字典
  exp1$symbol=rownames(exp1)
  exp1$approved_symbol=sapply(exp1$symbol,function(x)return(dict_HUGO[x])) #根据字典生成查询symbol对应的HUGO数据库中的现用名
  exp1$approved_symbol=ifelse(exp1$symbol %in% special.symbols,exp1$symbol,exp1$approved_symbol)#对应多个现用名且自己不是某基因的现用名的基因，因为不知道到底对应哪个基因，就先保留它自己
  exp1$approved_symbol=ifelse(is.na(exp1$approved_symbol),exp1$symbol,exp1$approved_symbol)#没有对应HUGO现用名的基因，可能是一个弹针对应多个基因的情况，这种情况也保留它自己
  
  df_new1=exp1
  index=order(rowMeans(df_new1[,!colnames(df_new1)%in%c('symbol','approved_symbol')]),decreasing = T)
  df_new1_ordered=df_new1[index,]
  keep=!duplicated((df_new1_ordered$approved_symbol))
  df_new1_ordered=df_new1_ordered[keep,]
  exp1=df_new1_ordered
  rownames(exp1)=exp1$approved_symbol
  exp1=exp1[,!colnames(exp1)%in%c('symbol','approved_symbol')]
  
  # exp1$rowname=rownames(exp1)#---------到这里--------------
  
  #根据genesymbol获取ENSEMBL_id
  library(org.Hs.eg.db)
  exp1=as.data.frame(exp1)
  exp1$gene_symbol=rownames(exp1)
  exp1$ENSEMBL_id<-sapply(mapIds(org.Hs.eg.db,
                                 keys = exp1$gene_symbol,
                                 column = 'ENSEMBL',
                                 keytype = 'SYMBOL',
                                 multiVals = 'list'),function(x) paste(x,collapse = ','))
 
  
  
  #去除列名中其他的东西，只保留其中GSM...的部分以及gene_symbol ensembl_id两列
  # exp1=as.data.frame(data_expr)
  library(stringr)
  colnames(exp1)=sapply(colnames(exp1),function(x){
    if(x %in% c('gene_symbol','ENSEMBL_id')){
      return(x)
    } else{
      return(str_extract(x,'GSM\\d*'))
    }
  })
}



#step2 读取患者信息文件
if(first_time_for_pdata==T){
#用GEOquery包下载GSE数据集的Series_matrix


#数据处理：1.获取矩阵后对总体表达量进行矫正
library(GEOquery)
library(stringr)
# library(tidyverse)
#网速不快才用，本地有文件就不用了
# library(GEOmirror)
# eSet=geoChina(GEO_id)
#如果可以正常下载，就不用镜像了
#下载文件
gset=getGEO(filename = paste0('H:/HIV_microarray_data_GEO/',tiss_type,'/',platform_id,'_affymetrix/',GEO_id,'_series_matrix.txt.gz'),destdir = '.',GSEMatrix = T,AnnotGPL = F,getGPL = F)
#查看pdata数据框的分组信息情况
pdata=pData(gset[1])

table(pdata$source_name_ch1)
#如果series_matrix未提供信息，需要自己设置分组
#手动分组 不推荐使用，只在分组不明确时用
#读取分组文件
group_table=read.table(paste0('data/',GEO_id,'_group.txt'),sep = '\t',header = T)
pdata$sample_id=rownames(pdata)
pdata=merge(pdata,group_table,by='sample_id')
write.table(pdata,file = paste0('results/',GEO_id,'_pdata.txt'),sep = '\t',quote = F)
sample2id=pdata[,which(colnames(pdata) %in% c('geo_accession','group'))]
#根据分组列信息分配组名
pdata=pdata[pdata$source_name_ch1=='PBMC samples at week 0',]
pdata$group='HIV_ART'
sample2id=pdata[,which(colnames(pdata) %in% c('geo_accession','group'))]
write.table(pdata,file = paste0('results/',GEO_id,'_pdata.txt'),sep = '\t',quote = F)
#强制指定每种方法的分组
pdata=pdata %>%
  # filter(column!='c') %>%
  # mutate(group=ifelse(title=='Patient 1','HIV_nonART',ifelse(title=='Patient 2','HIV_ART',ifelse(title=='Patient 3','HIV_ART',NA))))
  mutate(group=ifelse(grepl('tumor',`tissue:ch1`),'tumor',ifelse(grepl('normal',`tissue:ch1`) ,'nontumor',NA)))
setwd('H:/project')
write.table(pdata,file = paste0('results/',GEO_id,'_pdata.txt'),sep = '\t',quote = F)
sample2id=pdata[,which(colnames(pdata) %in% c('geo_accession','group'))]




}else{
  pdata=read.table(paste0('H:/project/results/',tiss_type,'/affymetrix/matrix/',GEO_id,'_pdata.txt'),sep = '\t',fill = T,header = F,row.names = NULL,quote = "")
  # pdata[1,ncol(pdata)]="" #有时候excel处理过的pdata格式正确但是对应位置是NA，就需要填一个空的东西进去
  if(pdata[1,ncol(pdata)]=='' | is.na(pdata[1,ncol(pdata)])){
    pdata[1,]=c('',pdata[1,-length(pdata[1,])])
    colnames(pdata)=pdata[1,]
    pdata=pdata[-1,]
    rownames(pdata)=pdata[,1]
    pdata=pdata[,-1]
  }else if(ncol(pdata)==2){
    colnames(pdata)=pdata[1,]
    pdata=pdata[-1,]
  }else{stop('Check pdata file, fix it manually if the problem is too complicated!')
  }
  sample2id=pdata[,which(colnames(pdata) %in% c('geo_accession','group'))]
}

# step3 数据整合，生成结果
if(perform_result_creation==T){
  
  
  
  #表达矩阵列名后面添加分组信息
  dict=setNames(sample2id$group,sample2id$geo_accession)#生成一个表达矩阵列名于accession_id对应关系的字典
  colnames(exp1)=paste0(colnames(exp1),'_',dict[colnames(exp1)])
  colnames(exp1)[which(colnames(exp1)=='gene_symbol_NA')]='gene_symbol'
  colnames(exp1)[which(colnames(exp1)=='ENSEMBL_id_NA')]='ENSEMBL_id'
  write.table(exp1,file = paste0('results/',GEO_id,'_expression_matrix_all_group.txt'),sep = '\t',quote = F)
  
  
  #制作每种分组的表达矩阵
  
  generate1group_matrix=function(sample2id,input_matrix){
    group_type=unique(sample2id$group)
    fun1=function(group_input){
      return_matrix=input_matrix[,which(grepl(group_input,colnames(input_matrix)))]
      return_matrix$gene_symbol=input_matrix$gene
      return_matrix$ENSEMBL_id=input_matrix$ENSEMBL
      write.table(return_matrix,file = paste0('results/',GEO_id,'_',group_input,'_matrix.txt'),sep = '\t',quote = F)
    }
    sapply(group_type,fun1)
  }
  generate1group_matrix(sample2id = sample2id,input_matrix = exp1)
  
}

