remove(list = ls())
if (!requireNamespace("here", quietly = TRUE)) install.packages("here")
library(here)
setwd(here::here())
#读取数据库的相互作用关系文件
df_database=read.delim('./data/TF-Target_relation_fin.txt')
df_database$ART=rep(NA,nrow(df_database))
df_database$nonART=rep(NA,nrow(df_database))
df_database1=df_database
#读取输入数据的文件
df_input=read.delim('./data/dNADC_comma-seperate.txt')
for (type in c('ART','nonART')) {
  type='ART'
  print(type)
  df_sub1=df_input[df_input$type==type,]
  remove(valid_rows)
  for (cancer in unique(df_input$cancer)) {
    # cancer='STAD'
    print(cancer)
    df_sub2=df_sub1[df_sub1$cancer==cancer,]
    condition_id=paste(cancer,sep = '_')
    gene_all=unlist(strsplit(df_sub2$All_list,','))
    gene_lasso=unlist(strsplit(df_sub2$LASSO_list,','))
    valid_rows <- df_database1[is.na(df_database1$condition_GRNdb) | grepl(cancer, df_database1$condition_GRNdb), ]
    for (i in 1:nrow(valid_rows)) {
      symbol = valid_rows$Target[i]
      
      # 判断 symbol 是否在 gene_all 或 gene_lasso 列表中
      matching_conditions = c()
      if (symbol %in% gene_all) {
        matching_conditions = paste0(condition_id,'_A')
      }
      if (symbol %in% gene_lasso) {
        matching_conditions = paste0(condition_id,'_L')
      }
      
      # 假设 valid_rows$condition[i] 存储了当前基因的所有条件
      if (length(matching_conditions) > 0) {
        if(type=='ART'){
          # 如果 condition 列已有内容，则在原内容基础上追加新的条件
          if (!is.na(valid_rows$ART[i])) {
            valid_rows$ART[i] <- paste(valid_rows$ART[i], paste(matching_conditions, collapse = ", "), sep = ", ")
          } else {
            # 否则直接赋值
            valid_rows$ART[i] <- paste(matching_conditions, collapse = ",")
          }
        }else{
          # 如果 condition 列已有内容，则在原内容基础上追加新的条件
          if (!is.na(valid_rows$nonART[i])) {
            valid_rows$nonART[i] <- paste(valid_rows$nonART[i], paste(matching_conditions, collapse = ", "), sep = ", ")
          } else {
            # 否则直接赋值
            valid_rows$nonART[i] <- paste(matching_conditions, collapse = ",")
          }
        }
        
        
      }
    }
    df_database1[rownames(valid_rows),]=valid_rows
  }
}
TF_list=unique(df_database1$TF[!(is.na(df_database1$ART)&is.na(df_database1$nonART))])

#添加转录因子和target的信息
df_database1=df_database1[!(is.na(df_database1$ART)&is.na(df_database1$nonART)),]

write.table(df_database1,file = './results/dNADC_TF_table.txt',sep = '\t',quote = F,row.names = F)

